import { View, Text, StyleSheet, ScrollView } from "react-native";
import React from "react";
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";
import { capitalized } from "../../../../../../helper/capitalized";
import useLangTranslation from "../../../../../../hooks/useLangTranslation";

const RenderItem = ({ itemKey, value }) => {

    return (
        <View style={specificationStyle.tableData}>
            <View 
                style={[
                    specificationStyle.specsWidth,
                    specificationStyle.borderRight,
                ]}
            >
                <Text style={specificationStyle.dataFont}>
                    {capitalized(itemKey)}
                </Text>
            </View>
            <Text
                style={[
                    specificationStyle.detailsWidth,
                    specificationStyle.dataFont,
                ]}
            >
                {value.map((v, i) => {
                    if (value.length - 1 == i) return v;
                    else return `${v}, `;
                })}
            </Text>
        </View>
    );
};

const Specification = ({ specification }) => {
    const { trans } = useLangTranslation();
    return (
        <View style={specificationStyle.container}>
            <View>
                <View style={specificationStyle.tableHeader}>
                    <View 
                        style={[
                            specificationStyle.specsWidth,
                            specificationStyle.borderRight,
                        ]}
                    >
                        <Text style={specificationStyle.headerFont}>
                            {trans("Attributes")}
                        </Text>
                    </View>
                    <Text
                        style={[
                            specificationStyle.headerFont,
                            specificationStyle.detailsWidth,
                        ]}
                    >
                        {trans("Details")}
                    </Text>
                </View>
                <ScrollView>
                    {Object.keys(specification).map((key, i) => {
                        return (
                            <RenderItem
                                itemKey={key}
                                value={specification[key]}
                                key={i}
                            />
                        );
                    })}
                </ScrollView>
            </View>
        </View>
    );
};

export default Specification;

const specificationStyle = StyleSheet.create({
    container: {
        padding: dpr(20),
        backgroundColor: "#fff",
    },
    tableHeader: {
        flexDirection: "row",
        borderWidth: 1,
        borderColor: "#DFDFDF",
    },
    headerFont: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        lineHeight: dpr(22),
        color: "#000",
        textAlign: "center",
        paddingHorizontal: 15,
        paddingVertical: 8,
    },
    specsWidth: {
        width: "40%",
    },
    detailsWidth: {
        width: "60%",
    },
    tableBorder: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
    },
    tableData: {
        flexDirection: "row",
        borderBottomWidth: 1,
        borderRightWidth: 1,
        borderLeftWidth: 1,
        borderColor: "#DFDFDF",
    },
    dataFont: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(13),
        color: "#898989",
        lineHeight: dpr(22),
        padding: 15,
    },
    borderRight: {
        borderRightWidth: 1,
        borderColor: "#DFDFDF",
    },
});
